/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.IHornHarvestable;
import vazkii.botania.common.block.subtile.functional.SubTileBergamute;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemHorn
extends Item {
    public ItemHorn(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void m_5929_(Level world, @Nonnull LivingEntity living, @Nonnull ItemStack stack, int time) {
        if (!world.f_46443_) {
            if (time != this.m_8105_(stack) && time % 5 == 0) {
                ItemHorn.breakGrass(world, stack, living.m_142538_());
            }
            world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), ModSounds.hornDoot, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void breakGrass(Level world, ItemStack stack, BlockPos srcPos) {
        IHornHarvestable harvestable;
        BlockEntity be;
        IHornHarvestable.EnumHornType type = null;
        if (stack.m_150930_(ModItems.grassHorn)) {
            type = IHornHarvestable.EnumHornType.WILD;
        } else if (stack.m_150930_(ModItems.leavesHorn)) {
            type = IHornHarvestable.EnumHornType.CANOPY;
        } else if (stack.m_150930_(ModItems.snowHorn)) {
            type = IHornHarvestable.EnumHornType.COVERING;
        }
        int range = 12 - type.ordinal() * 3;
        int rangeY = 3 + type.ordinal() * 4;
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)srcPos.m_142082_(-range, -rangeY, -range), (BlockPos)srcPos.m_142082_(range, rangeY, range))) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            be = world.m_7702_(pos);
            harvestable = IXplatAbstractions.INSTANCE.findHornHarvestable(world, pos, state, be);
            if (SubTileBergamute.isBergamuteNearby(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) || !(harvestable != null ? harvestable.canHornHarvest(world, pos, stack, type) : type == IHornHarvestable.EnumHornType.WILD && block instanceof BushBlock && !state.m_204336_(ModTags.Blocks.SPECIAL_FLOWERS) || type == IHornHarvestable.EnumHornType.CANOPY && state.m_204336_(BlockTags.f_13035_) || type == IHornHarvestable.EnumHornType.COVERING && state.m_60713_(Blocks.f_50125_))) continue;
            coords.add(pos.m_7949_());
        }
        Collections.shuffle(coords, world.f_46441_);
        int count = Math.min(coords.size(), 32 + type.ordinal() * 16);
        for (int i = 0; i < count; ++i) {
            BlockState state;
            BlockPos currCoords = (BlockPos)coords.get(i);
            harvestable = IXplatAbstractions.INSTANCE.findHornHarvestable(world, currCoords, state = world.m_8055_(currCoords), be = world.m_7702_(currCoords));
            if (harvestable != null && harvestable.hasSpecialHornHarvest(world, currCoords, stack, type)) {
                harvestable.harvestByHorn(world, currCoords, stack, type);
                continue;
            }
            world.m_46961_(currCoords, true);
        }
    }
}

